package jamezo97.clonecraft;

import java.util.EnumSet;

import net.minecraft.network.INetworkManager;
import net.minecraft.network.NetLoginHandler;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet1Login;
import net.minecraft.server.MinecraftServer;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;

public class CommonProxy implements IConnectionHandler{
	
static int CCEntityPlayerMPID;

	public void load(CloneCraft craft){
		Logger.log("Loading the common stuff");
		
		int EntitySpawnEggID;
		EntityRegistry.registerGlobalEntityID(jamezo97.clonecraft.entity.EntitySpawnEgg.class, "EntitySpawnEgg", EntitySpawnEggID = EntityRegistry.findGlobalUniqueEntityId());
		EntityRegistry.registerModEntity(jamezo97.clonecraft.entity.EntitySpawnEgg.class, "EntitySpawnEgg", EntitySpawnEggID, craft, 80, 10, true);
		
		int EntityCloneID;
		
		EntityRegistry.registerGlobalEntityID(jamezo97.clonecraft.entity.clone.EntityClone.class, "EntityClone", EntityCloneID = EntityRegistry.findGlobalUniqueEntityId(), 0x00afaf, 0x463aa5);
		EntityRegistry.registerModEntity(jamezo97.clonecraft.entity.clone.EntityClone.class, "EntityClone", EntityCloneID, craft, 512, 2, true);
		CloneCraft.cloneId = EntityCloneID;
		
		int EntityCustomID;
		EntityRegistry.registerGlobalEntityID(net.minecraft.entity.CCEntityAnything.class, "EntityCustom", EntityCustomID = EntityRegistry.findGlobalUniqueEntityId(), 0xffafaf, 0x463aff);
		EntityRegistry.registerModEntity(net.minecraft.entity.CCEntityAnything.class, "EntityCustom", EntityCustomID, craft, 512, 2, true);
		
//		int CCEntityPlayerMPID;
		EntityRegistry.registerGlobalEntityID(net.minecraft.entity.player.CCEntityPlayerMP.class, "CCEntityPlayerMP", CCEntityPlayerMPID = EntityRegistry.findGlobalUniqueEntityId(), 0xffafaf, 0x463aff);
		EntityRegistry.registerModEntity(net.minecraft.entity.player.CCEntityPlayerMP.class, "CCEntityPlayerMP", CCEntityPlayerMPID, craft, 512, 2, true);
		
		
		NetworkRegistry.instance().registerGuiHandler(this, new GuiHandler());
		NetworkRegistry.instance().registerConnectionHandler(this);
		
		GameRegistry.registerTileEntity(jamezo97.clonecraft.block.TileEntityCentrifuge.class, "Centrifuge");
		GameRegistry.registerTileEntity(jamezo97.clonecraft.block.TileEntitySterilizer.class, "Sterilizer");
		GameRegistry.registerTileEntity(jamezo97.clonecraft.block.TileEntityLifeInducer.class, "LifeInducer");
		GameRegistry.registerTileEntity(jamezo97.clonecraft.block.TileEntityDNASequencer.class, "DNASequencer");
		GameRegistry.registerTileEntity(jamezo97.clonecraft.block.TileEntityGeneExtractor.class, "GeneExtractor");
		
		TickRegistry.registerTickHandler(new ITickHandler(){

			@Override
			public void tickStart(EnumSet<TickType> type, Object... tickData) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void tickEnd(EnumSet<TickType> type, Object... tickData) {
				CloneCraft.instance.spawnEntitiesAfterTick();
			}

			@Override
			public EnumSet<TickType> ticks() {
				return EnumSet.of(TickType.SERVER);
			}

			@Override
			public String getLabel() {
				return "CCServerTicker";
			}
			
		}, Side.SERVER);
	
		
//		EntityRegistry.instance()
	}
	
	

	public void postInit() {
		
	}
	
	
	
	
	
	
	@Override
	public void playerLoggedIn(Player playerz, NetHandler netHandler, INetworkManager manager) {
		CloneCraft.instance.loadGenesIntoPlayer(netHandler.getPlayer());
	}

	@Override
	public String connectionReceived(NetLoginHandler netHandler,
			INetworkManager manager) {
		return null;
	}

	@Override
	public void connectionOpened(NetHandler netClientHandler, String server,
			int port, INetworkManager manager) {
	}

	@Override
	public void connectionOpened(NetHandler netClientHandler,
			MinecraftServer server, INetworkManager manager) {
	}

	@Override
	public void connectionClosed(INetworkManager manager) {
//		manager.
	}

	@Override
	public void clientLoggedIn(NetHandler clientHandler,
			INetworkManager manager, Packet1Login login) {
	}

}
